/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.helper;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.jpa.customer.Address;
import de.qfm.erp.service.model.jpa.customer.ContactPerson;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.customer.EAddressType;
import de.qfm.erp.service.model.jpa.customer.ECustomerState;
import de.qfm.erp.service.service.service.MessageService;
import java.time.LocalDate;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Range;

public final class CustomerHelper {
    public static final Joiner TEXT_JOINER = Joiner.on((String)" | ").skipNulls();

    @Nonnull
    public static Optional<Address> firstActiveQuotationAddress(@NonNull Customer customer) {
        if (customer == null) {
            throw new NullPointerException("customer is marked non-null but is null");
        }
        Set addresses = (Set)MoreObjects.firstNonNull((Object)customer.getAddresses(), (Object)ImmutableSet.of());
        return addresses.stream().filter(item -> item.getAddressType() == EAddressType.QUOTATION).filter(item -> null != item.getValidBegin() && null != item.getValidEnd()).filter(item -> (item.getValidBegin().isBefore(DateTimeHelper.today()) || item.getValidBegin().isEqual(DateTimeHelper.today())) && item.getValidEnd().isAfter(DateTimeHelper.today())).min((l, r) -> r.getValidBegin().compareTo(l.getValidBegin()));
    }

    @Nonnull
    public static String contactPersonText(@NonNull ContactPerson contactPerson, boolean withTitle) {
        if (contactPerson == null) {
            throw new NullPointerException("contactPerson is marked non-null but is null");
        }
        String salutation = StringUtils.trimToEmpty((String)contactPerson.getSalutation());
        String title = withTitle ? StringUtils.trimToEmpty((String)contactPerson.getTitle()) : "";
        String firstName = StringUtils.trimToEmpty((String)contactPerson.getFirstName());
        String lastName = StringUtils.trimToEmpty((String)contactPerson.getLastName());
        return ImmutableList.of((Object)salutation, (Object)title, (Object)firstName, (Object)lastName).stream().filter(StringUtils::isNotBlank).collect(Collectors.joining(" "));
    }

    @Nonnull
    public static Optional<Address> firstValidPrimaryAddress(@NonNull Customer customer) {
        if (customer == null) {
            throw new NullPointerException("customer is marked non-null but is null");
        }
        Set addresses = (Set)MoreObjects.firstNonNull((Object)customer.getAddresses(), (Object)ImmutableSet.of());
        return addresses.stream().filter(item -> item.getAddressType() == EAddressType.PRIMARY).filter(item -> Range.closed((Object)item.getValidBegin(), (Object)item.getValidEnd()).contains((Object)DateTimeHelper.today(), LocalDate::compareTo)).findFirst();
    }

    @Nonnull
    public static String customerText(@NonNull MessageService messageService, @NonNull Customer entity) {
        Object textWithState;
        if (messageService == null) {
            throw new NullPointerException("messageService is marked non-null but is null");
        }
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        ECustomerState customerState = (ECustomerState)MoreObjects.firstNonNull((Object)entity.getCustomerState(), (Object)ECustomerState.UNKNOWN);
        String text = TEXT_JOINER.join((Object)StringUtils.trimToEmpty((String)entity.getName()), (Object)StringUtils.trimToEmpty((String)entity.getDebtorAccountNumber()), new Object[0]);
        if (customerState == ECustomerState.TEMPORARY) {
            String customerStateText = String.format("(%s)", messageService.get((Translatable)customerState, new Object[0]));
            textWithState = text + " " + customerStateText;
        } else {
            textWithState = text;
        }
        return textWithState;
    }

    @Nonnull
    public static String addressText(@NonNull Address address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        String name = StringUtils.trimToEmpty((String)address.getName());
        String street = StringUtils.trimToEmpty((String)(StringUtils.trimToEmpty((String)address.getStreet()) + " " + StringUtils.trimToEmpty((String)address.getStreetNo())));
        String zipCode = StringUtils.trimToEmpty((String)address.getZipCode());
        String city = StringUtils.trimToEmpty((String)address.getCity());
        return ImmutableList.of((Object)name, (Object)street, (Object)zipCode, (Object)city).stream().filter(StringUtils::isNotBlank).collect(Collectors.joining(" "));
    }
}

