/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.filter;

import com.google.common.base.Stopwatch;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.WebUtils;

public class AppQRequestLoggingFilter
extends OncePerRequestFilter {
    private static final Logger log = LogManager.getLogger(AppQRequestLoggingFilter.class);
    private static final boolean INCLUDE_PAYLOAD = true;
    private static final boolean INCLUDE_QUERY_STRING = true;
    private static final boolean INCLUDE_CLIENT_INFO = true;
    private static final boolean INCLUDE_HEADER = false;
    private static final int PAYLOAD_LENGTH = 5000;
    public static final String DEFAULT_BEFORE_MESSAGE_PREFIX = "Before request [";
    public static final String DEFAULT_BEFORE_MESSAGE_SUFFIX = "]";
    public static final String DEFAULT_AFTER_MESSAGE_PREFIX = "[";
    public static final String DEFAULT_AFTER_MESSAGE_SUFFIX = "]";

    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        boolean isFirstRequest = !this.isAsyncDispatch(request);
        HttpServletRequest requestToUse = request;
        if (isFirstRequest && !(request instanceof ContentCachingRequestWrapper)) {
            requestToUse = new ContentCachingRequestWrapper(request, 5000);
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (isFirstRequest) {
            // empty if block
        }
        try {
            filterChain.doFilter((ServletRequest)requestToUse, (ServletResponse)response);
        }
        finally {
            if (!this.isAsyncStarted(requestToUse)) {
                long elapsed = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                this.afterRequest(requestToUse, this.getAfterMessage(requestToUse, elapsed));
            }
        }
    }

    private String getBeforeMessage(HttpServletRequest request) {
        return this.createMessage(request, DEFAULT_BEFORE_MESSAGE_PREFIX, "]", false, 0L);
    }

    private String getAfterMessage(HttpServletRequest request, long millis) {
        return this.createMessage(request, DEFAULT_AFTER_MESSAGE_PREFIX, "]", true, millis);
    }

    protected String createMessage(HttpServletRequest request, String prefix, String suffix, boolean writeMillis, long millis) {
        String payload;
        HttpSession session;
        StringBuilder msg = new StringBuilder();
        msg.append(prefix);
        msg.append(request.getMethod()).append(" ");
        msg.append(request.getRequestURI());
        String queryString = request.getQueryString();
        if (queryString != null) {
            msg.append('?').append(queryString);
        }
        String client = request.getRemoteAddr();
        String user = request.getRemoteUser();
        if (user != null) {
            msg.append(", user=").append(user);
        }
        if (writeMillis) {
            msg.append(", duration=").append(millis).append("ms");
        }
        if (StringUtils.hasLength((String)client) && !org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)"127.0.0.1", (CharSequence)client)) {
            msg.append(", client=").append(client);
        }
        if ((session = request.getSession(false)) != null) {
            msg.append(", session=").append(session.getId());
        }
        if ((payload = this.getMessagePayload(request)) != null) {
            msg.append(", payload=").append(payload);
        }
        msg.append(suffix);
        return msg.toString();
    }

    @Nullable
    protected String getMessagePayload(HttpServletRequest request) {
        byte[] buf;
        ContentCachingRequestWrapper wrapper = (ContentCachingRequestWrapper)WebUtils.getNativeRequest((ServletRequest)request, ContentCachingRequestWrapper.class);
        if (wrapper != null && (buf = wrapper.getContentAsByteArray()).length > 0) {
            int length = Math.min(buf.length, 5000);
            try {
                return new String(buf, 0, length, wrapper.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException ex) {
                return "[unknown]";
            }
        }
        return null;
    }

    protected void beforeRequest(HttpServletRequest request, String message) {
        log.info(message);
    }

    protected void afterRequest(HttpServletRequest request, String message) {
        log.info(message);
    }
}

