/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.filter.JwtTokenFilter;
import de.qfm.erp.service.service.security.JwtTokenProvider;
import jakarta.servlet.Filter;
import java.util.Map;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.DelegatingPasswordEncoder;
import org.springframework.security.crypto.password.MessageDigestPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.firewall.StrictHttpFirewall;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@Order(value=200)
public class WebSecurityAdapter {
    private final JwtTokenProvider jwtTokenProvider;

    @Bean
    public AuthenticationProvider authenticationProvider(UserDetailsService userDetailsService, PasswordEncoder passwordEncoder) {
        DaoAuthenticationProvider authProvider = new DaoAuthenticationProvider();
        authProvider.setUserDetailsService(userDetailsService);
        authProvider.setPasswordEncoder(passwordEncoder);
        return authProvider;
    }

    @Bean
    public AuthenticationManager customAuthenticationManager(AuthenticationConfiguration config) throws Exception {
        return config.getAuthenticationManager();
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        http.csrf(AbstractHttpConfigurer::disable);
        http.sessionManagement(httpSecuritySessionManagementConfigurer -> httpSecuritySessionManagementConfigurer.sessionCreationPolicy(SessionCreationPolicy.STATELESS));
        http.authorizeHttpRequests(authorizationManagerRequestMatcherRegistry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry.requestMatchers(new String[]{"/monitoring/health/"})).permitAll().requestMatchers(new String[]{"/api/v1/erp/errors/**"})).permitAll().requestMatchers(new String[]{"/api/v1/erp/auth/_signin/"})).permitAll().requestMatchers(new String[]{"/api/v1/erp/auth/_refresh/"})).permitAll().requestMatchers(new String[]{"/api/v1/erp/messages/**"})).permitAll().requestMatchers(new String[]{"/api/v1/erp-ws/**"})).permitAll().requestMatchers(new String[]{"/api/v1/erp/**"})).authenticated().requestMatchers(new String[]{"/api/v2/erp/**"})).authenticated());
        http.addFilterBefore((Filter)JwtTokenFilter.of((RequestMatcher)new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher("/api/v1/erp/**"), new AntPathRequestMatcher("/api/v2/erp/**")}), (JwtTokenProvider)this.jwtTokenProvider), UsernamePasswordAuthenticationFilter.class);
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public HttpFirewall allowUrlEncodedPercentHttpFirewall() {
        StrictHttpFirewall firewall = new StrictHttpFirewall();
        firewall.setAllowUrlEncodedSlash(true);
        firewall.setAllowUrlEncodedPercent(true);
        firewall.setAllowUrlEncodedPeriod(true);
        return firewall;
    }

    @Bean
    public WebSecurityCustomizer webSecurityCustomizer() {
        return web -> ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().requestMatchers(new String[]{"/v3/api-docs/**"})).requestMatchers(new String[]{"/swagger-resources/**"})).requestMatchers(new String[]{"/swagger-ui/**"})).requestMatchers(new String[]{"/swagger-ui.html"})).requestMatchers(new String[]{"/configuration/**"})).requestMatchers(new String[]{"/webjars/**"})).requestMatchers(new String[]{"/public"});
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        MessageDigestPasswordEncoder passwordEncoder = new MessageDigestPasswordEncoder("SHA-256");
        ImmutableMap encoders = ImmutableMap.of((Object)"bcrypt_12", (Object)new BCryptPasswordEncoder(12), (Object)"sha256", (Object)passwordEncoder);
        return new DelegatingPasswordEncoder("bcrypt_12", (Map)encoders);
    }

    public WebSecurityAdapter(JwtTokenProvider jwtTokenProvider) {
        this.jwtTokenProvider = jwtTokenProvider;
    }
}

