/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import de.leancoders.sharepoint.model.SharepointConfig;
import de.leancoders.sharepoint.service.SharepointClientService;
import de.leancoders.sharepoint.service.SharepointDriveClientService;
import jakarta.annotation.PostConstruct;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@PropertySources(value={@PropertySource(value={"classpath:sharepoint-config-default.properties"}, ignoreResourceNotFound=true, encoding="UTF-8"), @PropertySource(value={"classpath:/config/sharepoint-config.properties"}, ignoreResourceNotFound=true, encoding="UTF-8")})
public class SharepointConfiguration
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(SharepointConfiguration.class);
    @Value(value="${sharepoint.enabled:false}")
    private boolean enabled;
    @Value(value="${sharepoint.auth.baseUri:}")
    private String authUri;
    @Value(value="${sharepoint.auth.port:443}")
    private int authPort;
    @Value(value="${sharepoint.graph.baseUri:}")
    private String graphUri;
    @Value(value="${sharepoint.graph.port:443}")
    private int graphPort;
    @Value(value="${app.clientId:}")
    private String appClientId;
    @Value(value="${app.clientSecret:}")
    private String appClientSecret;
    @Value(value="${app.tenantId}")
    private String appTenantId;
    @Value(value="${sharepoint.siteId:}")
    private String sharepointSiteId;
    @Value(value="${sharepoint.driveId:}")
    private String sharepointDriveId;
    @Value(value="${sharepoint.drive.path:}")
    private String sharepointDrivePathString;
    @Value(value="${sharepoint.customer.root}")
    private String sharepointCustomerRootString;
    @Value(value="${sharepoint.customer.path}")
    private String sharepointCustomerPathString;
    private String sharepointDrivePath;
    private String sharepointCustomerRoot;
    private String sharepointCustomerPath;
    private SharepointConfig sharepointConfig;

    public void afterPropertiesSet() {
        this.sharepointDrivePath = SharepointConfiguration.clean((String)StringUtils.trimToEmpty((String)this.sharepointDrivePathString));
        this.sharepointCustomerRoot = SharepointConfiguration.clean((String)StringUtils.trimToEmpty((String)this.sharepointCustomerRootString));
        this.sharepointCustomerPath = SharepointConfiguration.clean((String)StringUtils.trimToEmpty((String)this.sharepointCustomerPathString));
        this.sharepointConfig = SharepointConfig.of((String)this.authUri, (int)this.authPort, (String)this.graphUri, (int)this.graphPort, (String)this.appClientId, (String)this.appClientSecret, (String)this.appTenantId);
    }

    @NonNull
    private static String clean(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        String s1 = StringUtils.removeStart((String)input, (String)"/");
        String s2 = StringUtils.removeEnd((String)s1, (String)"/");
        log.info("Cleaned DriveId: '{}'", (Object)s2);
        return s2;
    }

    @Bean
    public SharepointDriveClientService sharepointDriveClientService() {
        return new SharepointDriveClientService(this.sharepointConfig, new SharepointClientService(this.sharepointConfig));
    }

    @PostConstruct
    public void postConstruct() {
        log.info("Loaded SharepointConfig: {}", (Object)this);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getAuthUri() {
        return this.authUri;
    }

    public int getAuthPort() {
        return this.authPort;
    }

    public String getGraphUri() {
        return this.graphUri;
    }

    public int getGraphPort() {
        return this.graphPort;
    }

    public String getAppClientId() {
        return this.appClientId;
    }

    public String getAppClientSecret() {
        return this.appClientSecret;
    }

    public String getAppTenantId() {
        return this.appTenantId;
    }

    public String getSharepointSiteId() {
        return this.sharepointSiteId;
    }

    public String getSharepointDriveId() {
        return this.sharepointDriveId;
    }

    public String getSharepointDrivePathString() {
        return this.sharepointDrivePathString;
    }

    public String getSharepointCustomerRootString() {
        return this.sharepointCustomerRootString;
    }

    public String getSharepointCustomerPathString() {
        return this.sharepointCustomerPathString;
    }

    public String getSharepointDrivePath() {
        return this.sharepointDrivePath;
    }

    public String getSharepointCustomerRoot() {
        return this.sharepointCustomerRoot;
    }

    public String getSharepointCustomerPath() {
        return this.sharepointCustomerPath;
    }

    public SharepointConfig getSharepointConfig() {
        return this.sharepointConfig;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setAuthUri(String authUri) {
        this.authUri = authUri;
    }

    public void setAuthPort(int authPort) {
        this.authPort = authPort;
    }

    public void setGraphUri(String graphUri) {
        this.graphUri = graphUri;
    }

    public void setGraphPort(int graphPort) {
        this.graphPort = graphPort;
    }

    public void setAppClientId(String appClientId) {
        this.appClientId = appClientId;
    }

    public void setAppClientSecret(String appClientSecret) {
        this.appClientSecret = appClientSecret;
    }

    public void setAppTenantId(String appTenantId) {
        this.appTenantId = appTenantId;
    }

    public void setSharepointSiteId(String sharepointSiteId) {
        this.sharepointSiteId = sharepointSiteId;
    }

    public void setSharepointDriveId(String sharepointDriveId) {
        this.sharepointDriveId = sharepointDriveId;
    }

    public void setSharepointDrivePathString(String sharepointDrivePathString) {
        this.sharepointDrivePathString = sharepointDrivePathString;
    }

    public void setSharepointCustomerRootString(String sharepointCustomerRootString) {
        this.sharepointCustomerRootString = sharepointCustomerRootString;
    }

    public void setSharepointCustomerPathString(String sharepointCustomerPathString) {
        this.sharepointCustomerPathString = sharepointCustomerPathString;
    }

    public void setSharepointDrivePath(String sharepointDrivePath) {
        this.sharepointDrivePath = sharepointDrivePath;
    }

    public void setSharepointCustomerRoot(String sharepointCustomerRoot) {
        this.sharepointCustomerRoot = sharepointCustomerRoot;
    }

    public void setSharepointCustomerPath(String sharepointCustomerPath) {
        this.sharepointCustomerPath = sharepointCustomerPath;
    }

    public void setSharepointConfig(SharepointConfig sharepointConfig) {
        this.sharepointConfig = sharepointConfig;
    }

    public String toString() {
        return "SharepointConfiguration(enabled=" + this.isEnabled() + ", authUri=" + this.getAuthUri() + ", authPort=" + this.getAuthPort() + ", graphUri=" + this.getGraphUri() + ", graphPort=" + this.getGraphPort() + ", appClientId=" + this.getAppClientId() + ", appClientSecret=" + this.getAppClientSecret() + ", appTenantId=" + this.getAppTenantId() + ", sharepointSiteId=" + this.getSharepointSiteId() + ", sharepointDriveId=" + this.getSharepointDriveId() + ", sharepointDrivePathString=" + this.getSharepointDrivePathString() + ", sharepointCustomerRootString=" + this.getSharepointCustomerRootString() + ", sharepointCustomerPathString=" + this.getSharepointCustomerPathString() + ", sharepointDrivePath=" + this.getSharepointDrivePath() + ", sharepointCustomerRoot=" + this.getSharepointCustomerRoot() + ", sharepointCustomerPath=" + this.getSharepointCustomerPath() + ", sharepointConfig=" + String.valueOf(this.getSharepointConfig()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SharepointConfiguration)) {
            return false;
        }
        SharepointConfiguration other = (SharepointConfiguration)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getAuthPort() != other.getAuthPort()) {
            return false;
        }
        if (this.getGraphPort() != other.getGraphPort()) {
            return false;
        }
        String this$authUri = this.getAuthUri();
        String other$authUri = other.getAuthUri();
        if (this$authUri == null ? other$authUri != null : !this$authUri.equals(other$authUri)) {
            return false;
        }
        String this$graphUri = this.getGraphUri();
        String other$graphUri = other.getGraphUri();
        if (this$graphUri == null ? other$graphUri != null : !this$graphUri.equals(other$graphUri)) {
            return false;
        }
        String this$appClientId = this.getAppClientId();
        String other$appClientId = other.getAppClientId();
        if (this$appClientId == null ? other$appClientId != null : !this$appClientId.equals(other$appClientId)) {
            return false;
        }
        String this$appClientSecret = this.getAppClientSecret();
        String other$appClientSecret = other.getAppClientSecret();
        if (this$appClientSecret == null ? other$appClientSecret != null : !this$appClientSecret.equals(other$appClientSecret)) {
            return false;
        }
        String this$appTenantId = this.getAppTenantId();
        String other$appTenantId = other.getAppTenantId();
        if (this$appTenantId == null ? other$appTenantId != null : !this$appTenantId.equals(other$appTenantId)) {
            return false;
        }
        String this$sharepointSiteId = this.getSharepointSiteId();
        String other$sharepointSiteId = other.getSharepointSiteId();
        if (this$sharepointSiteId == null ? other$sharepointSiteId != null : !this$sharepointSiteId.equals(other$sharepointSiteId)) {
            return false;
        }
        String this$sharepointDriveId = this.getSharepointDriveId();
        String other$sharepointDriveId = other.getSharepointDriveId();
        if (this$sharepointDriveId == null ? other$sharepointDriveId != null : !this$sharepointDriveId.equals(other$sharepointDriveId)) {
            return false;
        }
        String this$sharepointDrivePathString = this.getSharepointDrivePathString();
        String other$sharepointDrivePathString = other.getSharepointDrivePathString();
        if (this$sharepointDrivePathString == null ? other$sharepointDrivePathString != null : !this$sharepointDrivePathString.equals(other$sharepointDrivePathString)) {
            return false;
        }
        String this$sharepointCustomerRootString = this.getSharepointCustomerRootString();
        String other$sharepointCustomerRootString = other.getSharepointCustomerRootString();
        if (this$sharepointCustomerRootString == null ? other$sharepointCustomerRootString != null : !this$sharepointCustomerRootString.equals(other$sharepointCustomerRootString)) {
            return false;
        }
        String this$sharepointCustomerPathString = this.getSharepointCustomerPathString();
        String other$sharepointCustomerPathString = other.getSharepointCustomerPathString();
        if (this$sharepointCustomerPathString == null ? other$sharepointCustomerPathString != null : !this$sharepointCustomerPathString.equals(other$sharepointCustomerPathString)) {
            return false;
        }
        String this$sharepointDrivePath = this.getSharepointDrivePath();
        String other$sharepointDrivePath = other.getSharepointDrivePath();
        if (this$sharepointDrivePath == null ? other$sharepointDrivePath != null : !this$sharepointDrivePath.equals(other$sharepointDrivePath)) {
            return false;
        }
        String this$sharepointCustomerRoot = this.getSharepointCustomerRoot();
        String other$sharepointCustomerRoot = other.getSharepointCustomerRoot();
        if (this$sharepointCustomerRoot == null ? other$sharepointCustomerRoot != null : !this$sharepointCustomerRoot.equals(other$sharepointCustomerRoot)) {
            return false;
        }
        String this$sharepointCustomerPath = this.getSharepointCustomerPath();
        String other$sharepointCustomerPath = other.getSharepointCustomerPath();
        if (this$sharepointCustomerPath == null ? other$sharepointCustomerPath != null : !this$sharepointCustomerPath.equals(other$sharepointCustomerPath)) {
            return false;
        }
        SharepointConfig this$sharepointConfig = this.getSharepointConfig();
        SharepointConfig other$sharepointConfig = other.getSharepointConfig();
        return !(this$sharepointConfig == null ? other$sharepointConfig != null : !this$sharepointConfig.equals(other$sharepointConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SharepointConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getAuthPort();
        result = result * 59 + this.getGraphPort();
        String $authUri = this.getAuthUri();
        result = result * 59 + ($authUri == null ? 43 : $authUri.hashCode());
        String $graphUri = this.getGraphUri();
        result = result * 59 + ($graphUri == null ? 43 : $graphUri.hashCode());
        String $appClientId = this.getAppClientId();
        result = result * 59 + ($appClientId == null ? 43 : $appClientId.hashCode());
        String $appClientSecret = this.getAppClientSecret();
        result = result * 59 + ($appClientSecret == null ? 43 : $appClientSecret.hashCode());
        String $appTenantId = this.getAppTenantId();
        result = result * 59 + ($appTenantId == null ? 43 : $appTenantId.hashCode());
        String $sharepointSiteId = this.getSharepointSiteId();
        result = result * 59 + ($sharepointSiteId == null ? 43 : $sharepointSiteId.hashCode());
        String $sharepointDriveId = this.getSharepointDriveId();
        result = result * 59 + ($sharepointDriveId == null ? 43 : $sharepointDriveId.hashCode());
        String $sharepointDrivePathString = this.getSharepointDrivePathString();
        result = result * 59 + ($sharepointDrivePathString == null ? 43 : $sharepointDrivePathString.hashCode());
        String $sharepointCustomerRootString = this.getSharepointCustomerRootString();
        result = result * 59 + ($sharepointCustomerRootString == null ? 43 : $sharepointCustomerRootString.hashCode());
        String $sharepointCustomerPathString = this.getSharepointCustomerPathString();
        result = result * 59 + ($sharepointCustomerPathString == null ? 43 : $sharepointCustomerPathString.hashCode());
        String $sharepointDrivePath = this.getSharepointDrivePath();
        result = result * 59 + ($sharepointDrivePath == null ? 43 : $sharepointDrivePath.hashCode());
        String $sharepointCustomerRoot = this.getSharepointCustomerRoot();
        result = result * 59 + ($sharepointCustomerRoot == null ? 43 : $sharepointCustomerRoot.hashCode());
        String $sharepointCustomerPath = this.getSharepointCustomerPath();
        result = result * 59 + ($sharepointCustomerPath == null ? 43 : $sharepointCustomerPath.hashCode());
        SharepointConfig $sharepointConfig = this.getSharepointConfig();
        result = result * 59 + ($sharepointConfig == null ? 43 : $sharepointConfig.hashCode());
        return result;
    }
}

