/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import jakarta.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class Q1Config
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(Q1Config.class);
    @Value(value="${q1.measurement.request.url}")
    private String measurementRequestUrl;
    @Value(value="${q1.employee.request.url}")
    private String employeeRequestUrl;
    @Value(value="${q1.request.timeout}")
    private long requestTimeout;
    @Value(value="${q1.measurement.push.enabled}")
    private boolean measurementPushEnabled;
    @Value(value="${q1.employee.push.enabled}")
    private boolean employeePushEnabled;

    public void afterPropertiesSet() {
    }

    @PostConstruct
    public void postConstruct() {
        log.info("Loaded Q1Config: {}", (Object)this);
    }

    public String getMeasurementRequestUrl() {
        return this.measurementRequestUrl;
    }

    public String getEmployeeRequestUrl() {
        return this.employeeRequestUrl;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public boolean isMeasurementPushEnabled() {
        return this.measurementPushEnabled;
    }

    public boolean isEmployeePushEnabled() {
        return this.employeePushEnabled;
    }

    public void setMeasurementRequestUrl(String measurementRequestUrl) {
        this.measurementRequestUrl = measurementRequestUrl;
    }

    public void setEmployeeRequestUrl(String employeeRequestUrl) {
        this.employeeRequestUrl = employeeRequestUrl;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setMeasurementPushEnabled(boolean measurementPushEnabled) {
        this.measurementPushEnabled = measurementPushEnabled;
    }

    public void setEmployeePushEnabled(boolean employeePushEnabled) {
        this.employeePushEnabled = employeePushEnabled;
    }

    public String toString() {
        return "Q1Config(measurementRequestUrl=" + this.getMeasurementRequestUrl() + ", employeeRequestUrl=" + this.getEmployeeRequestUrl() + ", requestTimeout=" + this.getRequestTimeout() + ", measurementPushEnabled=" + this.isMeasurementPushEnabled() + ", employeePushEnabled=" + this.isEmployeePushEnabled() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Q1Config)) {
            return false;
        }
        Q1Config other = (Q1Config)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getRequestTimeout() != other.getRequestTimeout()) {
            return false;
        }
        if (this.isMeasurementPushEnabled() != other.isMeasurementPushEnabled()) {
            return false;
        }
        if (this.isEmployeePushEnabled() != other.isEmployeePushEnabled()) {
            return false;
        }
        String this$measurementRequestUrl = this.getMeasurementRequestUrl();
        String other$measurementRequestUrl = other.getMeasurementRequestUrl();
        if (this$measurementRequestUrl == null ? other$measurementRequestUrl != null : !this$measurementRequestUrl.equals(other$measurementRequestUrl)) {
            return false;
        }
        String this$employeeRequestUrl = this.getEmployeeRequestUrl();
        String other$employeeRequestUrl = other.getEmployeeRequestUrl();
        return !(this$employeeRequestUrl == null ? other$employeeRequestUrl != null : !this$employeeRequestUrl.equals(other$employeeRequestUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Q1Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $requestTimeout = this.getRequestTimeout();
        result = result * 59 + (int)($requestTimeout >>> 32 ^ $requestTimeout);
        result = result * 59 + (this.isMeasurementPushEnabled() ? 79 : 97);
        result = result * 59 + (this.isEmployeePushEnabled() ? 79 : 97);
        String $measurementRequestUrl = this.getMeasurementRequestUrl();
        result = result * 59 + ($measurementRequestUrl == null ? 43 : $measurementRequestUrl.hashCode());
        String $employeeRequestUrl = this.getEmployeeRequestUrl();
        result = result * 59 + ($employeeRequestUrl == null ? 43 : $employeeRequestUrl.hashCode());
        return result;
    }
}

