/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;

@Configuration
public class LocaleAndMessagingConfiguration {
    public static final String STANDARD = "messageSource";
    public static final String HISTORY = "messageSourceHistory";
    public static final String PRIVILEGES = "messageSourcePrivileges";
    public static final String PAYROLL_MONTH = "messageSourcePayrollMonth";
    public static final String PRINT = "messageSourcePrint";
    public static final String INDEX_FIELDS = "messageSourceIndexFields";

    @Bean(name={"localeResolver"})
    public LocaleResolver localeResolver() {
        return new AcceptHeaderLocaleResolver();
    }

    @Bean(name={"messageSource"})
    public MessageSource messageSource() {
        ReloadableResourceBundleMessageSource messageResource = new ReloadableResourceBundleMessageSource();
        messageResource.setBasename("classpath:i18n/messages");
        messageResource.setDefaultEncoding("UTF-8");
        return messageResource;
    }

    @Bean(name={"messageSourceHistory"})
    public MessageSource messageSourceHistory() {
        ReloadableResourceBundleMessageSource messageResource = new ReloadableResourceBundleMessageSource();
        messageResource.setBasename("classpath:i18n/history_fields");
        messageResource.setDefaultEncoding("UTF-8");
        return messageResource;
    }

    @Bean(name={"messageSourceIndexFields"})
    public MessageSource messageResourceIndexFields() {
        ReloadableResourceBundleMessageSource messageResource = new ReloadableResourceBundleMessageSource();
        messageResource.setBasename("classpath:i18n/index_fields");
        messageResource.setDefaultEncoding("UTF-8");
        return messageResource;
    }

    @Bean(name={"messageSourcePrivileges"})
    public MessageSource messageResourcePrivileges() {
        ReloadableResourceBundleMessageSource messageResource = new ReloadableResourceBundleMessageSource();
        messageResource.setBasename("classpath:i18n/privileges");
        messageResource.setDefaultEncoding("UTF-8");
        return messageResource;
    }

    @Bean(name={"messageSourcePrint"})
    public MessageSource messageResourcePrint() {
        ReloadableResourceBundleMessageSource messageResource = new ReloadableResourceBundleMessageSource();
        messageResource.setBasename("classpath:i18n/stage_print_boiler_plate");
        messageResource.setDefaultEncoding("UTF-8");
        return messageResource;
    }

    @Bean(name={"messageSourcePayrollMonth"})
    public MessageSource messageResourcePayrollMonth() {
        ReloadableResourceBundleMessageSource messageResource = new ReloadableResourceBundleMessageSource();
        messageResource.setBasename("classpath:i18n/payroll_month");
        messageResource.setDefaultEncoding("UTF-8");
        return messageResource;
    }
}

