/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import jakarta.annotation.PostConstruct;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.core.io.support.PropertySourceFactory;

@Configuration
@PropertySources(value={@PropertySource(value={"file:./file-store-config.properties"}, ignoreResourceNotFound=true, factory=PropertySourceFactory.class), @PropertySource(value={"${PROPERTIES_PATH}/file-store-config.properties"}, ignoreResourceNotFound=true, factory=PropertySourceFactory.class), @PropertySource(value={"file:/var/www/html/qfm-web-api/file-store-config.properties"}, ignoreResourceNotFound=true, factory=PropertySourceFactory.class)})
public class FileStoreConfig
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(FileStoreConfig.class);
    @Value(value="${invoice.file_store.enabled:true}")
    private boolean invoiceFileStoreEnabled;
    @Value(value="${invoice.file_store.location:}")
    private String invoiceFileStoreLocation;
    private Path fileStoreInvoicePath;

    @PostConstruct
    public void postConstruct() {
        this.fileStoreInvoicePath = Path.of(this.invoiceFileStoreLocation, new String[0]);
    }

    public void afterPropertiesSet() {
        log.info("Loaded CompanyConfig: {}", (Object)this);
    }

    public boolean isInvoiceFileStoreEnabled() {
        return this.invoiceFileStoreEnabled;
    }

    public String getInvoiceFileStoreLocation() {
        return this.invoiceFileStoreLocation;
    }

    public Path getFileStoreInvoicePath() {
        return this.fileStoreInvoicePath;
    }

    public void setInvoiceFileStoreEnabled(boolean invoiceFileStoreEnabled) {
        this.invoiceFileStoreEnabled = invoiceFileStoreEnabled;
    }

    public void setInvoiceFileStoreLocation(String invoiceFileStoreLocation) {
        this.invoiceFileStoreLocation = invoiceFileStoreLocation;
    }

    public void setFileStoreInvoicePath(Path fileStoreInvoicePath) {
        this.fileStoreInvoicePath = fileStoreInvoicePath;
    }

    public String toString() {
        return "FileStoreConfig(invoiceFileStoreEnabled=" + this.isInvoiceFileStoreEnabled() + ", invoiceFileStoreLocation=" + this.getInvoiceFileStoreLocation() + ", fileStoreInvoicePath=" + String.valueOf(this.getFileStoreInvoicePath()) + ")";
    }
}

