/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import de.qfm.erp.service.service.job.DirtyInvoiceDMSRefreshJob;
import de.qfm.erp.service.service.job.DirtyInvoiceStoreRefreshJob;
import de.qfm.erp.service.service.job.DirtyPsxNotifyJob;
import de.qfm.erp.service.service.job.DirtySharepointSyncRefreshJob;
import de.qfm.erp.service.service.job.DisableUserJob;
import de.qfm.erp.service.service.job.QueueProcessingJob;
import de.qfm.erp.service.service.job.StagePropagationJob;
import de.qfm.erp.service.service.route.InvoiceRoute;
import de.qfm.erp.service.service.route.PsxSyncRoute;
import de.qfm.erp.service.service.route.QueueRoute;
import de.qfm.erp.service.service.route.SharepointRoute;
import de.qfm.erp.service.service.route.StagePropagationRoute;
import de.qfm.erp.service.service.route.UserRoute;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@ConditionalOnProperty(value={"scheduler.enabled"}, havingValue="true")
@EnableScheduling
@ComponentScan(basePackages={"de.qfm.erp.service.service.job"}, excludeFilters={@ComponentScan.Filter(value={Configuration.class})})
public class EnableSchedulerConfig {
    private static final Logger log = LogManager.getLogger(EnableSchedulerConfig.class);

    @Bean
    public StagePropagationJob stagePropagationJob(@NonNull StagePropagationRoute route) {
        if (route == null) {
            throw new NullPointerException("route is marked non-null but is null");
        }
        return new StagePropagationJob(route);
    }

    @Bean
    public DirtyInvoiceDMSRefreshJob dirtyInvoiceDMSRefreshJob(@NonNull InvoiceRoute invoiceRoute) {
        if (invoiceRoute == null) {
            throw new NullPointerException("invoiceRoute is marked non-null but is null");
        }
        return new DirtyInvoiceDMSRefreshJob(invoiceRoute);
    }

    @Bean
    public DirtyInvoiceStoreRefreshJob dirtyInvoiceStoreRefreshJob(@NonNull InvoiceRoute invoiceRoute) {
        if (invoiceRoute == null) {
            throw new NullPointerException("invoiceRoute is marked non-null but is null");
        }
        return new DirtyInvoiceStoreRefreshJob(invoiceRoute);
    }

    @Bean
    public DirtyPsxNotifyJob dirtyPsxNotifyJob(@NonNull PsxSyncRoute psxSyncRoute) {
        if (psxSyncRoute == null) {
            throw new NullPointerException("psxSyncRoute is marked non-null but is null");
        }
        return new DirtyPsxNotifyJob(psxSyncRoute);
    }

    @Bean
    public QueueProcessingJob queueProcessingJob(@NonNull QueueRoute queueRoute) {
        if (queueRoute == null) {
            throw new NullPointerException("queueRoute is marked non-null but is null");
        }
        return new QueueProcessingJob(queueRoute);
    }

    @Bean
    public DisableUserJob disableUserJob(@NonNull UserRoute userRoute) {
        if (userRoute == null) {
            throw new NullPointerException("userRoute is marked non-null but is null");
        }
        return new DisableUserJob(userRoute);
    }

    @Bean
    public DirtySharepointSyncRefreshJob dirtySharepointSyncRefreshJob(@NonNull SharepointRoute sharepointRoute) {
        if (sharepointRoute == null) {
            throw new NullPointerException("sharepointRoute is marked non-null but is null");
        }
        return new DirtySharepointSyncRefreshJob(sharepointRoute);
    }
}

