/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import jakarta.annotation.PostConstruct;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.core.io.support.PropertySourceFactory;

@Configuration
@PropertySources(value={@PropertySource(value={"file:./diamant-config.properties"}, ignoreResourceNotFound=true, factory=PropertySourceFactory.class), @PropertySource(value={"${PROPERTIES_PATH}/diamant-config.properties"}, ignoreResourceNotFound=true, factory=PropertySourceFactory.class), @PropertySource(value={"file:/var/www/html/qfm-web-api/diamant-config.properties"}, ignoreResourceNotFound=true, factory=PropertySourceFactory.class)})
public class DiamantConfig
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(DiamantConfig.class);
    @Value(value="${diamant.enabled:false}")
    private boolean enabled;
    @Value(value="${diamant.folder.standard:}")
    private String folderStandard;
    @Value(value="${diamant.invoice.cost_accounting.enabled:true}")
    private boolean invoiceCostAccountingEnabled;
    private Path folderPathStandard;

    public void afterPropertiesSet() {
        Path pathStandard = Path.of(this.folderStandard, new String[0]);
        if (!pathStandard.toFile().exists()) {
            log.error("ERROR: Path: {} for DIAMANT is not accessible", (Object)this.folderStandard);
        }
        this.folderPathStandard = pathStandard;
    }

    @PostConstruct
    public void postConstruct() {
        log.info("Loaded DiamantConfig: {}", (Object)this);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getFolderStandard() {
        return this.folderStandard;
    }

    public boolean isInvoiceCostAccountingEnabled() {
        return this.invoiceCostAccountingEnabled;
    }

    public Path getFolderPathStandard() {
        return this.folderPathStandard;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setFolderStandard(String folderStandard) {
        this.folderStandard = folderStandard;
    }

    public void setInvoiceCostAccountingEnabled(boolean invoiceCostAccountingEnabled) {
        this.invoiceCostAccountingEnabled = invoiceCostAccountingEnabled;
    }

    public void setFolderPathStandard(Path folderPathStandard) {
        this.folderPathStandard = folderPathStandard;
    }

    public String toString() {
        return "DiamantConfig(enabled=" + this.isEnabled() + ", folderStandard=" + this.getFolderStandard() + ", invoiceCostAccountingEnabled=" + this.isInvoiceCostAccountingEnabled() + ", folderPathStandard=" + String.valueOf(this.getFolderPathStandard()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiamantConfig)) {
            return false;
        }
        DiamantConfig other = (DiamantConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isInvoiceCostAccountingEnabled() != other.isInvoiceCostAccountingEnabled()) {
            return false;
        }
        String this$folderStandard = this.getFolderStandard();
        String other$folderStandard = other.getFolderStandard();
        if (this$folderStandard == null ? other$folderStandard != null : !this$folderStandard.equals(other$folderStandard)) {
            return false;
        }
        Path this$folderPathStandard = this.getFolderPathStandard();
        Path other$folderPathStandard = other.getFolderPathStandard();
        return !(this$folderPathStandard == null ? other$folderPathStandard != null : !((Object)this$folderPathStandard).equals(other$folderPathStandard));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DiamantConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isInvoiceCostAccountingEnabled() ? 79 : 97);
        String $folderStandard = this.getFolderStandard();
        result = result * 59 + ($folderStandard == null ? 43 : $folderStandard.hashCode());
        Path $folderPathStandard = this.getFolderPathStandard();
        result = result * 59 + ($folderPathStandard == null ? 43 : ((Object)$folderPathStandard).hashCode());
        return result;
    }
}

