/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import jakarta.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DashboardConfig
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(DashboardConfig.class);
    @Value(value="${dashboard.construction.site.all.page.size}")
    private int constructionSiteAllPageSize;
    @Value(value="${dashboard.construction.site.filtered.max.page.size}")
    private int constructionSiteFilteredMaxPageSize;
    @Value(value="${dashboard.construction.site.unfiltered.max.page.size}")
    private int constructionSiteUnfilteredMaxPageSize;
    @Value(value="${dashboard.measurement.recent.page.size}")
    private int measurementRecentPageSize;

    public void afterPropertiesSet() {
    }

    @PostConstruct
    public void postConstruct() {
        log.info("Loaded DashboardConfig: {}", (Object)this);
    }

    public int getConstructionSiteAllPageSize() {
        return this.constructionSiteAllPageSize;
    }

    public int getConstructionSiteFilteredMaxPageSize() {
        return this.constructionSiteFilteredMaxPageSize;
    }

    public int getConstructionSiteUnfilteredMaxPageSize() {
        return this.constructionSiteUnfilteredMaxPageSize;
    }

    public int getMeasurementRecentPageSize() {
        return this.measurementRecentPageSize;
    }

    public void setConstructionSiteAllPageSize(int constructionSiteAllPageSize) {
        this.constructionSiteAllPageSize = constructionSiteAllPageSize;
    }

    public void setConstructionSiteFilteredMaxPageSize(int constructionSiteFilteredMaxPageSize) {
        this.constructionSiteFilteredMaxPageSize = constructionSiteFilteredMaxPageSize;
    }

    public void setConstructionSiteUnfilteredMaxPageSize(int constructionSiteUnfilteredMaxPageSize) {
        this.constructionSiteUnfilteredMaxPageSize = constructionSiteUnfilteredMaxPageSize;
    }

    public void setMeasurementRecentPageSize(int measurementRecentPageSize) {
        this.measurementRecentPageSize = measurementRecentPageSize;
    }

    public String toString() {
        return "DashboardConfig(constructionSiteAllPageSize=" + this.getConstructionSiteAllPageSize() + ", constructionSiteFilteredMaxPageSize=" + this.getConstructionSiteFilteredMaxPageSize() + ", constructionSiteUnfilteredMaxPageSize=" + this.getConstructionSiteUnfilteredMaxPageSize() + ", measurementRecentPageSize=" + this.getMeasurementRecentPageSize() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DashboardConfig)) {
            return false;
        }
        DashboardConfig other = (DashboardConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getConstructionSiteAllPageSize() != other.getConstructionSiteAllPageSize()) {
            return false;
        }
        if (this.getConstructionSiteFilteredMaxPageSize() != other.getConstructionSiteFilteredMaxPageSize()) {
            return false;
        }
        if (this.getConstructionSiteUnfilteredMaxPageSize() != other.getConstructionSiteUnfilteredMaxPageSize()) {
            return false;
        }
        return this.getMeasurementRecentPageSize() == other.getMeasurementRecentPageSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DashboardConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConstructionSiteAllPageSize();
        result = result * 59 + this.getConstructionSiteFilteredMaxPageSize();
        result = result * 59 + this.getConstructionSiteUnfilteredMaxPageSize();
        result = result * 59 + this.getMeasurementRecentPageSize();
        return result;
    }
}

