/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import jakarta.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.core.io.support.PropertySourceFactory;

@Configuration
@PropertySources(value={@PropertySource(value={"file:./config/company-config.properties"}, ignoreResourceNotFound=true, factory=PropertySourceFactory.class), @PropertySource(value={"${PROPERTIES_PATH}/company-config.properties"}, ignoreResourceNotFound=true, factory=PropertySourceFactory.class), @PropertySource(value={"file:/var/www/html/qfm-web-api/company-config.properties"}, ignoreResourceNotFound=true, factory=PropertySourceFactory.class)})
public class CompanyConfig
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(CompanyConfig.class);
    @Value(value="${company.name:XXX}")
    private String companyName;
    @Value(value="${sbs.file.name:BEWA-XXX.DAT}")
    private String sbsFileName;
    @Value(value="${sbs.bv.currency:E}")
    private String sbsCurrency;
    @Value(value="${sbs.mandant:XXX}")
    private String sbsMandant;
    @Value(value="${diamant.mandant:XXX}")
    private String diamantMandant;
    @Value(value="${contract_number.prefix.default:Q}")
    private String contractNumberPrefixDefault;

    @PostConstruct
    public void postConstruct() {
    }

    public void afterPropertiesSet() {
        log.info("Loaded CompanyConfig: {}", (Object)this);
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getSbsFileName() {
        return this.sbsFileName;
    }

    public String getSbsCurrency() {
        return this.sbsCurrency;
    }

    public String getSbsMandant() {
        return this.sbsMandant;
    }

    public String getDiamantMandant() {
        return this.diamantMandant;
    }

    public String getContractNumberPrefixDefault() {
        return this.contractNumberPrefixDefault;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public void setSbsFileName(String sbsFileName) {
        this.sbsFileName = sbsFileName;
    }

    public void setSbsCurrency(String sbsCurrency) {
        this.sbsCurrency = sbsCurrency;
    }

    public void setSbsMandant(String sbsMandant) {
        this.sbsMandant = sbsMandant;
    }

    public void setDiamantMandant(String diamantMandant) {
        this.diamantMandant = diamantMandant;
    }

    public void setContractNumberPrefixDefault(String contractNumberPrefixDefault) {
        this.contractNumberPrefixDefault = contractNumberPrefixDefault;
    }

    public String toString() {
        return "CompanyConfig(companyName=" + this.getCompanyName() + ", sbsFileName=" + this.getSbsFileName() + ", sbsCurrency=" + this.getSbsCurrency() + ", sbsMandant=" + this.getSbsMandant() + ", diamantMandant=" + this.getDiamantMandant() + ", contractNumberPrefixDefault=" + this.getContractNumberPrefixDefault() + ")";
    }
}

