/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.configuration;

import jakarta.annotation.PostConstruct;
import java.io.File;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Base64;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.format.annotation.DateTimeFormat;

@Configuration
public class ApplicationConfig
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(ApplicationConfig.class);
    private final LocalDate defaultEndDate = LocalDate.of(2049, 12, 31);
    @Value(value="${security.auth.password.encoding.enabled}")
    private boolean securityAuthPasswordEncodingEnabled;
    @Value(value="${security.cors.enabled}")
    private boolean securityCorsEnabled;
    @Value(value="${application.measurement.validation.accounting.range.minusday:180}")
    private long validationAccountingMinusDays;
    @Value(value="${application.measurement.validation.accounting.range.plusday:180}")
    private long validationAccountingPlusDays;
    @Value(value="${application.measurement.validation.construction.range.minusday:365}")
    private long validationConstructionMinusDays;
    @Value(value="${application.measurement.validation.construction.range.plusday:730}")
    private long validationConstructionPlusDays;
    @Value(value="${application.measurement.validation.construction-accounting.range.minus:30}")
    private long validationConstructionAccountingMinusDays;
    @Value(value="${application.measurement.validation.construction-accounting.range.plusday:90}")
    private long validationConstructionAccountingPlusDays;
    @Value(value="${application.invoice.double.final.invoice.validation.min.date:01.01.1900}")
    @DateTimeFormat(pattern="dd.MM.yyyy")
    private LocalDate validationDoubleFinalInvoiceValidationMinDate;
    @Value(value="${application.quotation.position.degree-of-fulfilment.batch.size:1000}")
    private int quotationPositionDegreeOfFulfilmentBatchSize;
    @Value(value="${application.measurement.listing.recent.days:90}")
    private int measurementListingRecentDays;
    @Value(value="${application.entity.usage.tracking}")
    private boolean entityUsageTracking;
    @Value(value="${application.entity.usage.tracking.cleanup.ttl.hours}")
    private int entityUsageTrackingCleanupTTLHours;
    @Value(value="${application.invoice.attachment.cleanup.enabled}")
    private boolean invoiceAttachmentCleanup;
    @Value(value="${application.invoice.attachment.cleanup.ttl.hours}")
    private int invoiceAttachmentCleanupTTLHours;
    @Value(value="${application.restrict.measurement.access.enabled}")
    private boolean restrictMeasurementAccessEnabled;
    @Value(value="${security.jwt.token.secret-key}")
    private String secretKeyPlain;
    @Value(value="${security.jwt.access-token.expire-length}")
    private long accessTokenValidityInSeconds;
    @Value(value="${security.jwt.refresh-token.expire-length}")
    private long refreshTokenValidityInSeconds;
    @Value(value="${queue.processing.max-tries}")
    private int queueProcessingMaxTries;
    private String secretKey;
    @Value(value="${stage.material_percentage.min}")
    private BigDecimal stageMaterialPercentageMin;
    @Value(value="${stage.material_percentage.standard}")
    private BigDecimal stageMaterialPercentageStandard;
    @Value(value="${stage.wage_percentage.min}")
    private BigDecimal stageWagePercentageMin;
    @Value(value="${stage.wage_percentage.standard}")
    private BigDecimal stageWagePercentageStandard;
    @Value(value="${stage.websocket.filter_myself:true}")
    private boolean stageWebSocketFilterMyself;
    @Value(value="${stage.websocket.filter_myself_duplicate:false}")
    private boolean stageWebSocketFilterMyselfDuplicate;
    @Value(value="${stage.websocket.filter_duplicate:true}")
    private boolean stageWebSocketFilterDuplicate;
    @Value(value="${user.wage_account.default.limit}")
    private BigDecimal userWageAccountDefaultLimit;
    @Value(value="${application.print.with.label.logo.blue}")
    private String measurementPrintLogoDefault;
    @Value(value="${application.print.without.label.logo.gray}")
    private String invoicePrintLogoDefault;
    @Value(value="${application.print.without.label.logo.blue}")
    private String stagePrintLogoDefault;
    @Value(value="${application.print.default.transparent}")
    private String printDefaultTransparent;
    @Value(value="${scheduler.stage.propagation.ms}")
    private int stagePropagationJobDelayMS;
    @Value(value="${global.search.auto.complete.max.timeout.ms}")
    private int globalSearchAutoCompleteMaxTimeoutMS;

    public void afterPropertiesSet() {
        this.secretKey = Base64.getEncoder().encodeToString(this.secretKeyPlain.getBytes());
    }

    @Nonnull
    private File applyFolderString(@NonNull String folderString, @NonNull String variable) {
        if (folderString == null) {
            throw new NullPointerException("folderString is marked non-null but is null");
        }
        if (variable == null) {
            throw new NullPointerException("variable is marked non-null but is null");
        }
        File dataFolderCandidate = new File(folderString);
        if (dataFolderCandidate.exists() && dataFolderCandidate.isDirectory()) {
            return dataFolderCandidate;
        }
        throw new IllegalArgumentException(String.format("%s is not accessible or not a folder, please check: %s", folderString, variable));
    }

    @Nonnull
    private File applyFileString(@NonNull String fileString, @NonNull String variable) {
        if (fileString == null) {
            throw new NullPointerException("fileString is marked non-null but is null");
        }
        if (variable == null) {
            throw new NullPointerException("variable is marked non-null but is null");
        }
        File fileCandidate = new File(fileString);
        if (fileCandidate.exists() && fileCandidate.isFile()) {
            return fileCandidate;
        }
        throw new IllegalArgumentException(String.format("%s is not accessible or not a file, please check: %s", fileCandidate, variable));
    }

    @PostConstruct
    public void postConstruct() {
        log.info("Loaded ApplicationConfig: {}", (Object)this);
    }

    public LocalDate getDefaultEndDate() {
        return this.defaultEndDate;
    }

    public boolean isSecurityAuthPasswordEncodingEnabled() {
        return this.securityAuthPasswordEncodingEnabled;
    }

    public boolean isSecurityCorsEnabled() {
        return this.securityCorsEnabled;
    }

    public long getValidationAccountingMinusDays() {
        return this.validationAccountingMinusDays;
    }

    public long getValidationAccountingPlusDays() {
        return this.validationAccountingPlusDays;
    }

    public long getValidationConstructionMinusDays() {
        return this.validationConstructionMinusDays;
    }

    public long getValidationConstructionPlusDays() {
        return this.validationConstructionPlusDays;
    }

    public long getValidationConstructionAccountingMinusDays() {
        return this.validationConstructionAccountingMinusDays;
    }

    public long getValidationConstructionAccountingPlusDays() {
        return this.validationConstructionAccountingPlusDays;
    }

    public LocalDate getValidationDoubleFinalInvoiceValidationMinDate() {
        return this.validationDoubleFinalInvoiceValidationMinDate;
    }

    public int getQuotationPositionDegreeOfFulfilmentBatchSize() {
        return this.quotationPositionDegreeOfFulfilmentBatchSize;
    }

    public int getMeasurementListingRecentDays() {
        return this.measurementListingRecentDays;
    }

    public boolean isEntityUsageTracking() {
        return this.entityUsageTracking;
    }

    public int getEntityUsageTrackingCleanupTTLHours() {
        return this.entityUsageTrackingCleanupTTLHours;
    }

    public boolean isInvoiceAttachmentCleanup() {
        return this.invoiceAttachmentCleanup;
    }

    public int getInvoiceAttachmentCleanupTTLHours() {
        return this.invoiceAttachmentCleanupTTLHours;
    }

    public boolean isRestrictMeasurementAccessEnabled() {
        return this.restrictMeasurementAccessEnabled;
    }

    public String getSecretKeyPlain() {
        return this.secretKeyPlain;
    }

    public long getAccessTokenValidityInSeconds() {
        return this.accessTokenValidityInSeconds;
    }

    public long getRefreshTokenValidityInSeconds() {
        return this.refreshTokenValidityInSeconds;
    }

    public int getQueueProcessingMaxTries() {
        return this.queueProcessingMaxTries;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public BigDecimal getStageMaterialPercentageMin() {
        return this.stageMaterialPercentageMin;
    }

    public BigDecimal getStageMaterialPercentageStandard() {
        return this.stageMaterialPercentageStandard;
    }

    public BigDecimal getStageWagePercentageMin() {
        return this.stageWagePercentageMin;
    }

    public BigDecimal getStageWagePercentageStandard() {
        return this.stageWagePercentageStandard;
    }

    public boolean isStageWebSocketFilterMyself() {
        return this.stageWebSocketFilterMyself;
    }

    public boolean isStageWebSocketFilterMyselfDuplicate() {
        return this.stageWebSocketFilterMyselfDuplicate;
    }

    public boolean isStageWebSocketFilterDuplicate() {
        return this.stageWebSocketFilterDuplicate;
    }

    public BigDecimal getUserWageAccountDefaultLimit() {
        return this.userWageAccountDefaultLimit;
    }

    public String getMeasurementPrintLogoDefault() {
        return this.measurementPrintLogoDefault;
    }

    public String getInvoicePrintLogoDefault() {
        return this.invoicePrintLogoDefault;
    }

    public String getStagePrintLogoDefault() {
        return this.stagePrintLogoDefault;
    }

    public String getPrintDefaultTransparent() {
        return this.printDefaultTransparent;
    }

    public int getStagePropagationJobDelayMS() {
        return this.stagePropagationJobDelayMS;
    }

    public int getGlobalSearchAutoCompleteMaxTimeoutMS() {
        return this.globalSearchAutoCompleteMaxTimeoutMS;
    }

    public void setSecurityAuthPasswordEncodingEnabled(boolean securityAuthPasswordEncodingEnabled) {
        this.securityAuthPasswordEncodingEnabled = securityAuthPasswordEncodingEnabled;
    }

    public void setSecurityCorsEnabled(boolean securityCorsEnabled) {
        this.securityCorsEnabled = securityCorsEnabled;
    }

    public void setValidationAccountingMinusDays(long validationAccountingMinusDays) {
        this.validationAccountingMinusDays = validationAccountingMinusDays;
    }

    public void setValidationAccountingPlusDays(long validationAccountingPlusDays) {
        this.validationAccountingPlusDays = validationAccountingPlusDays;
    }

    public void setValidationConstructionMinusDays(long validationConstructionMinusDays) {
        this.validationConstructionMinusDays = validationConstructionMinusDays;
    }

    public void setValidationConstructionPlusDays(long validationConstructionPlusDays) {
        this.validationConstructionPlusDays = validationConstructionPlusDays;
    }

    public void setValidationConstructionAccountingMinusDays(long validationConstructionAccountingMinusDays) {
        this.validationConstructionAccountingMinusDays = validationConstructionAccountingMinusDays;
    }

    public void setValidationConstructionAccountingPlusDays(long validationConstructionAccountingPlusDays) {
        this.validationConstructionAccountingPlusDays = validationConstructionAccountingPlusDays;
    }

    public void setValidationDoubleFinalInvoiceValidationMinDate(LocalDate validationDoubleFinalInvoiceValidationMinDate) {
        this.validationDoubleFinalInvoiceValidationMinDate = validationDoubleFinalInvoiceValidationMinDate;
    }

    public void setQuotationPositionDegreeOfFulfilmentBatchSize(int quotationPositionDegreeOfFulfilmentBatchSize) {
        this.quotationPositionDegreeOfFulfilmentBatchSize = quotationPositionDegreeOfFulfilmentBatchSize;
    }

    public void setMeasurementListingRecentDays(int measurementListingRecentDays) {
        this.measurementListingRecentDays = measurementListingRecentDays;
    }

    public void setEntityUsageTracking(boolean entityUsageTracking) {
        this.entityUsageTracking = entityUsageTracking;
    }

    public void setEntityUsageTrackingCleanupTTLHours(int entityUsageTrackingCleanupTTLHours) {
        this.entityUsageTrackingCleanupTTLHours = entityUsageTrackingCleanupTTLHours;
    }

    public void setInvoiceAttachmentCleanup(boolean invoiceAttachmentCleanup) {
        this.invoiceAttachmentCleanup = invoiceAttachmentCleanup;
    }

    public void setInvoiceAttachmentCleanupTTLHours(int invoiceAttachmentCleanupTTLHours) {
        this.invoiceAttachmentCleanupTTLHours = invoiceAttachmentCleanupTTLHours;
    }

    public void setRestrictMeasurementAccessEnabled(boolean restrictMeasurementAccessEnabled) {
        this.restrictMeasurementAccessEnabled = restrictMeasurementAccessEnabled;
    }

    public void setSecretKeyPlain(String secretKeyPlain) {
        this.secretKeyPlain = secretKeyPlain;
    }

    public void setAccessTokenValidityInSeconds(long accessTokenValidityInSeconds) {
        this.accessTokenValidityInSeconds = accessTokenValidityInSeconds;
    }

    public void setRefreshTokenValidityInSeconds(long refreshTokenValidityInSeconds) {
        this.refreshTokenValidityInSeconds = refreshTokenValidityInSeconds;
    }

    public void setQueueProcessingMaxTries(int queueProcessingMaxTries) {
        this.queueProcessingMaxTries = queueProcessingMaxTries;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setStageMaterialPercentageMin(BigDecimal stageMaterialPercentageMin) {
        this.stageMaterialPercentageMin = stageMaterialPercentageMin;
    }

    public void setStageMaterialPercentageStandard(BigDecimal stageMaterialPercentageStandard) {
        this.stageMaterialPercentageStandard = stageMaterialPercentageStandard;
    }

    public void setStageWagePercentageMin(BigDecimal stageWagePercentageMin) {
        this.stageWagePercentageMin = stageWagePercentageMin;
    }

    public void setStageWagePercentageStandard(BigDecimal stageWagePercentageStandard) {
        this.stageWagePercentageStandard = stageWagePercentageStandard;
    }

    public void setStageWebSocketFilterMyself(boolean stageWebSocketFilterMyself) {
        this.stageWebSocketFilterMyself = stageWebSocketFilterMyself;
    }

    public void setStageWebSocketFilterMyselfDuplicate(boolean stageWebSocketFilterMyselfDuplicate) {
        this.stageWebSocketFilterMyselfDuplicate = stageWebSocketFilterMyselfDuplicate;
    }

    public void setStageWebSocketFilterDuplicate(boolean stageWebSocketFilterDuplicate) {
        this.stageWebSocketFilterDuplicate = stageWebSocketFilterDuplicate;
    }

    public void setUserWageAccountDefaultLimit(BigDecimal userWageAccountDefaultLimit) {
        this.userWageAccountDefaultLimit = userWageAccountDefaultLimit;
    }

    public void setMeasurementPrintLogoDefault(String measurementPrintLogoDefault) {
        this.measurementPrintLogoDefault = measurementPrintLogoDefault;
    }

    public void setInvoicePrintLogoDefault(String invoicePrintLogoDefault) {
        this.invoicePrintLogoDefault = invoicePrintLogoDefault;
    }

    public void setStagePrintLogoDefault(String stagePrintLogoDefault) {
        this.stagePrintLogoDefault = stagePrintLogoDefault;
    }

    public void setPrintDefaultTransparent(String printDefaultTransparent) {
        this.printDefaultTransparent = printDefaultTransparent;
    }

    public void setStagePropagationJobDelayMS(int stagePropagationJobDelayMS) {
        this.stagePropagationJobDelayMS = stagePropagationJobDelayMS;
    }

    public void setGlobalSearchAutoCompleteMaxTimeoutMS(int globalSearchAutoCompleteMaxTimeoutMS) {
        this.globalSearchAutoCompleteMaxTimeoutMS = globalSearchAutoCompleteMaxTimeoutMS;
    }

    public String toString() {
        return "ApplicationConfig(defaultEndDate=" + String.valueOf(this.getDefaultEndDate()) + ", securityAuthPasswordEncodingEnabled=" + this.isSecurityAuthPasswordEncodingEnabled() + ", securityCorsEnabled=" + this.isSecurityCorsEnabled() + ", validationAccountingMinusDays=" + this.getValidationAccountingMinusDays() + ", validationAccountingPlusDays=" + this.getValidationAccountingPlusDays() + ", validationConstructionMinusDays=" + this.getValidationConstructionMinusDays() + ", validationConstructionPlusDays=" + this.getValidationConstructionPlusDays() + ", validationConstructionAccountingMinusDays=" + this.getValidationConstructionAccountingMinusDays() + ", validationConstructionAccountingPlusDays=" + this.getValidationConstructionAccountingPlusDays() + ", validationDoubleFinalInvoiceValidationMinDate=" + String.valueOf(this.getValidationDoubleFinalInvoiceValidationMinDate()) + ", quotationPositionDegreeOfFulfilmentBatchSize=" + this.getQuotationPositionDegreeOfFulfilmentBatchSize() + ", measurementListingRecentDays=" + this.getMeasurementListingRecentDays() + ", entityUsageTracking=" + this.isEntityUsageTracking() + ", entityUsageTrackingCleanupTTLHours=" + this.getEntityUsageTrackingCleanupTTLHours() + ", invoiceAttachmentCleanup=" + this.isInvoiceAttachmentCleanup() + ", invoiceAttachmentCleanupTTLHours=" + this.getInvoiceAttachmentCleanupTTLHours() + ", restrictMeasurementAccessEnabled=" + this.isRestrictMeasurementAccessEnabled() + ", secretKeyPlain=" + this.getSecretKeyPlain() + ", accessTokenValidityInSeconds=" + this.getAccessTokenValidityInSeconds() + ", refreshTokenValidityInSeconds=" + this.getRefreshTokenValidityInSeconds() + ", queueProcessingMaxTries=" + this.getQueueProcessingMaxTries() + ", secretKey=" + this.getSecretKey() + ", stageMaterialPercentageMin=" + String.valueOf(this.getStageMaterialPercentageMin()) + ", stageMaterialPercentageStandard=" + String.valueOf(this.getStageMaterialPercentageStandard()) + ", stageWagePercentageMin=" + String.valueOf(this.getStageWagePercentageMin()) + ", stageWagePercentageStandard=" + String.valueOf(this.getStageWagePercentageStandard()) + ", stageWebSocketFilterMyself=" + this.isStageWebSocketFilterMyself() + ", stageWebSocketFilterMyselfDuplicate=" + this.isStageWebSocketFilterMyselfDuplicate() + ", stageWebSocketFilterDuplicate=" + this.isStageWebSocketFilterDuplicate() + ", userWageAccountDefaultLimit=" + String.valueOf(this.getUserWageAccountDefaultLimit()) + ", measurementPrintLogoDefault=" + this.getMeasurementPrintLogoDefault() + ", invoicePrintLogoDefault=" + this.getInvoicePrintLogoDefault() + ", stagePrintLogoDefault=" + this.getStagePrintLogoDefault() + ", printDefaultTransparent=" + this.getPrintDefaultTransparent() + ", stagePropagationJobDelayMS=" + this.getStagePropagationJobDelayMS() + ", globalSearchAutoCompleteMaxTimeoutMS=" + this.getGlobalSearchAutoCompleteMaxTimeoutMS() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationConfig)) {
            return false;
        }
        ApplicationConfig other = (ApplicationConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isSecurityAuthPasswordEncodingEnabled() != other.isSecurityAuthPasswordEncodingEnabled()) {
            return false;
        }
        if (this.isSecurityCorsEnabled() != other.isSecurityCorsEnabled()) {
            return false;
        }
        if (this.getValidationAccountingMinusDays() != other.getValidationAccountingMinusDays()) {
            return false;
        }
        if (this.getValidationAccountingPlusDays() != other.getValidationAccountingPlusDays()) {
            return false;
        }
        if (this.getValidationConstructionMinusDays() != other.getValidationConstructionMinusDays()) {
            return false;
        }
        if (this.getValidationConstructionPlusDays() != other.getValidationConstructionPlusDays()) {
            return false;
        }
        if (this.getValidationConstructionAccountingMinusDays() != other.getValidationConstructionAccountingMinusDays()) {
            return false;
        }
        if (this.getValidationConstructionAccountingPlusDays() != other.getValidationConstructionAccountingPlusDays()) {
            return false;
        }
        if (this.getQuotationPositionDegreeOfFulfilmentBatchSize() != other.getQuotationPositionDegreeOfFulfilmentBatchSize()) {
            return false;
        }
        if (this.getMeasurementListingRecentDays() != other.getMeasurementListingRecentDays()) {
            return false;
        }
        if (this.isEntityUsageTracking() != other.isEntityUsageTracking()) {
            return false;
        }
        if (this.getEntityUsageTrackingCleanupTTLHours() != other.getEntityUsageTrackingCleanupTTLHours()) {
            return false;
        }
        if (this.isInvoiceAttachmentCleanup() != other.isInvoiceAttachmentCleanup()) {
            return false;
        }
        if (this.getInvoiceAttachmentCleanupTTLHours() != other.getInvoiceAttachmentCleanupTTLHours()) {
            return false;
        }
        if (this.isRestrictMeasurementAccessEnabled() != other.isRestrictMeasurementAccessEnabled()) {
            return false;
        }
        if (this.getAccessTokenValidityInSeconds() != other.getAccessTokenValidityInSeconds()) {
            return false;
        }
        if (this.getRefreshTokenValidityInSeconds() != other.getRefreshTokenValidityInSeconds()) {
            return false;
        }
        if (this.getQueueProcessingMaxTries() != other.getQueueProcessingMaxTries()) {
            return false;
        }
        if (this.isStageWebSocketFilterMyself() != other.isStageWebSocketFilterMyself()) {
            return false;
        }
        if (this.isStageWebSocketFilterMyselfDuplicate() != other.isStageWebSocketFilterMyselfDuplicate()) {
            return false;
        }
        if (this.isStageWebSocketFilterDuplicate() != other.isStageWebSocketFilterDuplicate()) {
            return false;
        }
        if (this.getStagePropagationJobDelayMS() != other.getStagePropagationJobDelayMS()) {
            return false;
        }
        if (this.getGlobalSearchAutoCompleteMaxTimeoutMS() != other.getGlobalSearchAutoCompleteMaxTimeoutMS()) {
            return false;
        }
        LocalDate this$defaultEndDate = this.getDefaultEndDate();
        LocalDate other$defaultEndDate = other.getDefaultEndDate();
        if (this$defaultEndDate == null ? other$defaultEndDate != null : !((Object)this$defaultEndDate).equals(other$defaultEndDate)) {
            return false;
        }
        LocalDate this$validationDoubleFinalInvoiceValidationMinDate = this.getValidationDoubleFinalInvoiceValidationMinDate();
        LocalDate other$validationDoubleFinalInvoiceValidationMinDate = other.getValidationDoubleFinalInvoiceValidationMinDate();
        if (this$validationDoubleFinalInvoiceValidationMinDate == null ? other$validationDoubleFinalInvoiceValidationMinDate != null : !((Object)this$validationDoubleFinalInvoiceValidationMinDate).equals(other$validationDoubleFinalInvoiceValidationMinDate)) {
            return false;
        }
        String this$secretKeyPlain = this.getSecretKeyPlain();
        String other$secretKeyPlain = other.getSecretKeyPlain();
        if (this$secretKeyPlain == null ? other$secretKeyPlain != null : !this$secretKeyPlain.equals(other$secretKeyPlain)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        BigDecimal this$stageMaterialPercentageMin = this.getStageMaterialPercentageMin();
        BigDecimal other$stageMaterialPercentageMin = other.getStageMaterialPercentageMin();
        if (this$stageMaterialPercentageMin == null ? other$stageMaterialPercentageMin != null : !((Object)this$stageMaterialPercentageMin).equals(other$stageMaterialPercentageMin)) {
            return false;
        }
        BigDecimal this$stageMaterialPercentageStandard = this.getStageMaterialPercentageStandard();
        BigDecimal other$stageMaterialPercentageStandard = other.getStageMaterialPercentageStandard();
        if (this$stageMaterialPercentageStandard == null ? other$stageMaterialPercentageStandard != null : !((Object)this$stageMaterialPercentageStandard).equals(other$stageMaterialPercentageStandard)) {
            return false;
        }
        BigDecimal this$stageWagePercentageMin = this.getStageWagePercentageMin();
        BigDecimal other$stageWagePercentageMin = other.getStageWagePercentageMin();
        if (this$stageWagePercentageMin == null ? other$stageWagePercentageMin != null : !((Object)this$stageWagePercentageMin).equals(other$stageWagePercentageMin)) {
            return false;
        }
        BigDecimal this$stageWagePercentageStandard = this.getStageWagePercentageStandard();
        BigDecimal other$stageWagePercentageStandard = other.getStageWagePercentageStandard();
        if (this$stageWagePercentageStandard == null ? other$stageWagePercentageStandard != null : !((Object)this$stageWagePercentageStandard).equals(other$stageWagePercentageStandard)) {
            return false;
        }
        BigDecimal this$userWageAccountDefaultLimit = this.getUserWageAccountDefaultLimit();
        BigDecimal other$userWageAccountDefaultLimit = other.getUserWageAccountDefaultLimit();
        if (this$userWageAccountDefaultLimit == null ? other$userWageAccountDefaultLimit != null : !((Object)this$userWageAccountDefaultLimit).equals(other$userWageAccountDefaultLimit)) {
            return false;
        }
        String this$measurementPrintLogoDefault = this.getMeasurementPrintLogoDefault();
        String other$measurementPrintLogoDefault = other.getMeasurementPrintLogoDefault();
        if (this$measurementPrintLogoDefault == null ? other$measurementPrintLogoDefault != null : !this$measurementPrintLogoDefault.equals(other$measurementPrintLogoDefault)) {
            return false;
        }
        String this$invoicePrintLogoDefault = this.getInvoicePrintLogoDefault();
        String other$invoicePrintLogoDefault = other.getInvoicePrintLogoDefault();
        if (this$invoicePrintLogoDefault == null ? other$invoicePrintLogoDefault != null : !this$invoicePrintLogoDefault.equals(other$invoicePrintLogoDefault)) {
            return false;
        }
        String this$stagePrintLogoDefault = this.getStagePrintLogoDefault();
        String other$stagePrintLogoDefault = other.getStagePrintLogoDefault();
        if (this$stagePrintLogoDefault == null ? other$stagePrintLogoDefault != null : !this$stagePrintLogoDefault.equals(other$stagePrintLogoDefault)) {
            return false;
        }
        String this$printDefaultTransparent = this.getPrintDefaultTransparent();
        String other$printDefaultTransparent = other.getPrintDefaultTransparent();
        return !(this$printDefaultTransparent == null ? other$printDefaultTransparent != null : !this$printDefaultTransparent.equals(other$printDefaultTransparent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApplicationConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSecurityAuthPasswordEncodingEnabled() ? 79 : 97);
        result = result * 59 + (this.isSecurityCorsEnabled() ? 79 : 97);
        long $validationAccountingMinusDays = this.getValidationAccountingMinusDays();
        result = result * 59 + (int)($validationAccountingMinusDays >>> 32 ^ $validationAccountingMinusDays);
        long $validationAccountingPlusDays = this.getValidationAccountingPlusDays();
        result = result * 59 + (int)($validationAccountingPlusDays >>> 32 ^ $validationAccountingPlusDays);
        long $validationConstructionMinusDays = this.getValidationConstructionMinusDays();
        result = result * 59 + (int)($validationConstructionMinusDays >>> 32 ^ $validationConstructionMinusDays);
        long $validationConstructionPlusDays = this.getValidationConstructionPlusDays();
        result = result * 59 + (int)($validationConstructionPlusDays >>> 32 ^ $validationConstructionPlusDays);
        long $validationConstructionAccountingMinusDays = this.getValidationConstructionAccountingMinusDays();
        result = result * 59 + (int)($validationConstructionAccountingMinusDays >>> 32 ^ $validationConstructionAccountingMinusDays);
        long $validationConstructionAccountingPlusDays = this.getValidationConstructionAccountingPlusDays();
        result = result * 59 + (int)($validationConstructionAccountingPlusDays >>> 32 ^ $validationConstructionAccountingPlusDays);
        result = result * 59 + this.getQuotationPositionDegreeOfFulfilmentBatchSize();
        result = result * 59 + this.getMeasurementListingRecentDays();
        result = result * 59 + (this.isEntityUsageTracking() ? 79 : 97);
        result = result * 59 + this.getEntityUsageTrackingCleanupTTLHours();
        result = result * 59 + (this.isInvoiceAttachmentCleanup() ? 79 : 97);
        result = result * 59 + this.getInvoiceAttachmentCleanupTTLHours();
        result = result * 59 + (this.isRestrictMeasurementAccessEnabled() ? 79 : 97);
        long $accessTokenValidityInSeconds = this.getAccessTokenValidityInSeconds();
        result = result * 59 + (int)($accessTokenValidityInSeconds >>> 32 ^ $accessTokenValidityInSeconds);
        long $refreshTokenValidityInSeconds = this.getRefreshTokenValidityInSeconds();
        result = result * 59 + (int)($refreshTokenValidityInSeconds >>> 32 ^ $refreshTokenValidityInSeconds);
        result = result * 59 + this.getQueueProcessingMaxTries();
        result = result * 59 + (this.isStageWebSocketFilterMyself() ? 79 : 97);
        result = result * 59 + (this.isStageWebSocketFilterMyselfDuplicate() ? 79 : 97);
        result = result * 59 + (this.isStageWebSocketFilterDuplicate() ? 79 : 97);
        result = result * 59 + this.getStagePropagationJobDelayMS();
        result = result * 59 + this.getGlobalSearchAutoCompleteMaxTimeoutMS();
        LocalDate $defaultEndDate = this.getDefaultEndDate();
        result = result * 59 + ($defaultEndDate == null ? 43 : ((Object)$defaultEndDate).hashCode());
        LocalDate $validationDoubleFinalInvoiceValidationMinDate = this.getValidationDoubleFinalInvoiceValidationMinDate();
        result = result * 59 + ($validationDoubleFinalInvoiceValidationMinDate == null ? 43 : ((Object)$validationDoubleFinalInvoiceValidationMinDate).hashCode());
        String $secretKeyPlain = this.getSecretKeyPlain();
        result = result * 59 + ($secretKeyPlain == null ? 43 : $secretKeyPlain.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        BigDecimal $stageMaterialPercentageMin = this.getStageMaterialPercentageMin();
        result = result * 59 + ($stageMaterialPercentageMin == null ? 43 : ((Object)$stageMaterialPercentageMin).hashCode());
        BigDecimal $stageMaterialPercentageStandard = this.getStageMaterialPercentageStandard();
        result = result * 59 + ($stageMaterialPercentageStandard == null ? 43 : ((Object)$stageMaterialPercentageStandard).hashCode());
        BigDecimal $stageWagePercentageMin = this.getStageWagePercentageMin();
        result = result * 59 + ($stageWagePercentageMin == null ? 43 : ((Object)$stageWagePercentageMin).hashCode());
        BigDecimal $stageWagePercentageStandard = this.getStageWagePercentageStandard();
        result = result * 59 + ($stageWagePercentageStandard == null ? 43 : ((Object)$stageWagePercentageStandard).hashCode());
        BigDecimal $userWageAccountDefaultLimit = this.getUserWageAccountDefaultLimit();
        result = result * 59 + ($userWageAccountDefaultLimit == null ? 43 : ((Object)$userWageAccountDefaultLimit).hashCode());
        String $measurementPrintLogoDefault = this.getMeasurementPrintLogoDefault();
        result = result * 59 + ($measurementPrintLogoDefault == null ? 43 : $measurementPrintLogoDefault.hashCode());
        String $invoicePrintLogoDefault = this.getInvoicePrintLogoDefault();
        result = result * 59 + ($invoicePrintLogoDefault == null ? 43 : $invoicePrintLogoDefault.hashCode());
        String $stagePrintLogoDefault = this.getStagePrintLogoDefault();
        result = result * 59 + ($stagePrintLogoDefault == null ? 43 : $stagePrintLogoDefault.hashCode());
        String $printDefaultTransparent = this.getPrintDefaultTransparent();
        result = result * 59 + ($printDefaultTransparent == null ? 43 : $printDefaultTransparent.hashCode());
        return result;
    }
}

